import Vue from "vue";
window.Vue = Vue;

window.axios = require("axios");
window.axios.defaults.headers.common["X-Requested-With"] = "XMLHttpRequest";
require("promise.prototype.finally").shim();

import { Form, HasError, AlertError } from "vform";
window.Form = Form;

Vue.component(HasError.name, HasError);
Vue.component(AlertError.name, AlertError);

Vue.component("pagination", require("laravel-vue-pagination"));


import VueCtkDateTimePicker from 'vue-ctk-date-time-picker';
import 'vue-ctk-date-time-picker/dist/vue-ctk-date-time-picker.css';
Vue.component('VueCtkDateTimePicker', VueCtkDateTimePicker);

//sweet alert 2

import swal from "sweetalert2";
window.swal = swal;
const toast = swal.mixin({
    toast: true,
    position: "top-end",
    showConfirmButton: false,
    timer: 15000
});
window.toast = toast;

//vue lang

import VueInternationalization from "vue-i18n";
import Locale from "./vue-i18n-locales.generated";

Vue.use(VueInternationalization);

const lang = document.documentElement.lang.substr(0, 2);
// or however you determine your current app locale

const i18n = new VueInternationalization({
    locale: lang,
    messages: Locale
});

//vue lang end

//https://hamed-ehtesham.github.io/pretty-checkbox-vue/#installation

import PrettyCheckbox from "pretty-checkbox-vue";
Vue.use(PrettyCheckbox);

//vue autocomplete

//ckeditor

import CKEditor from "@ckeditor/ckeditor5-vue";
Vue.use(CKEditor);


/**
 * Next, we will create a fresh Vue ap
 *
 *
 * plication instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

// dash board
Vue.component(
    "logged-common-view-all-notification-component",
    require("./components/LoggedCommon/AllNotificationsComponent.vue")
);

Vue.component(
    "dashboard-site-latest-employee-attendance-list",
    require("./components/dashboard/site/LatestEmployeeAttendanceComponent.vue")
);
Vue.component(
    "dashboard-site-latest-student-attendance-list",
    require("./components/dashboard/site/latestStudentAttendanceListComponent.vue")
);

Vue.component(
    "dashboard-site-employee-attendance-graph",
    require("./components/dashboard/site/dashboardEmployeeAttendanceGraphComponent.vue")
);


// EDU INTERNAL-..------------------------------------START---------------------
Vue.component(
    "site-group-fee-multiple-student-payment-component",
    require("./components/site_group/fee/SiteGroupFeeMultipleStudentPaymentComponent.vue")
);
Vue.component(
    "site-group-version-year-shift-dept-class-group-component",
    require("./components/site_group/SiteGroupVersionYearShiftDeptClassGroupComponent.vue")
);
Vue.component(
    "site-group-fee-generate-component",
    require("./components/site_group/fee/SiteGroupFeeGenerateComponent.vue")
);
Vue.component(
    "site-group-waiver-generate-gomponent",
    require("./components/site_group/fee/SiteGroupWaiverGenerateComponent.vue")
);
Vue.component(
    "site-group-fee-single-student-payment-component",
    require("./components/site_group/fee/SiteGroupFeeSingleStudentPaymentComponent.vue")
);
Vue.component(
    "site-group-demand-slip-generate-component",
    require("./components/site_group/fee/SiteGroupDemandSlipGenerateComponent.vue")
);
Vue.component(
    "site-group-fee-allocation-component",
    require("./components/site_group/fee/SiteGroupFeeAllocationComponent.vue")
);
Vue.component(
    "site-group-fee-head-subhead-group-setting-component",
    require("./components/site_group/fee/SiteGroupFeeHeadSubHeadGroupSettingComponent.vue")
);
Vue.component(
    "site-group-users-list",
    require("./components/site_group/SiteGroupUserComponent.vue")
);



/* ====Global filter START =========================*/

Vue.filter("activeInactive", function(value) {
    if (value == 1) {
        return "Active";
    } else {
        return "Inactive";
    }
});
Vue.filter("yesNo", function(value) {
    if (value == 1) {
        return "Yes";
    } else {
        return "No";
    }
});
import moment from "moment";

Vue.filter("formatTime", function(value) {
    if (value) {
        return moment(String(value), ["HH:mm"]).format("hh:mm A");
    }
});

Vue.filter("formatTimeSec", function(value) {
    if (value) {
        return moment(String(value), ["HH:mm:ss"]).format("hh:mm:ss A");
    }
});
Vue.filter("formatDateTime", function(value) {
    if (value) {
        return moment(String(value)).format("DD MMMM YYYY hh:mm A");
    }
});
Vue.filter("formatDayMonth", function(value) {
    if (value) {
        return moment(String(value), ["dd:mm"]).format("dd:mm");
    }
});
Vue.filter("formatMinDiff", function(stTime, endTime) {
    //console.log(stTime+' '+endTime)

    var startTime = moment(stTime, "hh:mm:ss");
    var endTime = moment(endTime, "hh:mm:ss");
    var mins = moment
        .utc(moment(endTime, "hh:mm:ss").diff(moment(startTime, "hh:mm:ss")))
        .format("mm");
    return mins + " mins";
});
Vue.filter("formatDate", function(value) {
    console.log(value);
    if (value) {
        return moment(String(value)).format("DD MMMM YYYY");
    }
});

//capitalize --- apple->Apple
Vue.filter("capitalize", function(value) {
    if (!value) return "";
    return value.charAt(0).toUpperCase() + value.slice(1);
});

//remove html tags
Vue.filter("striphtml", function(value) {
    var div = document.createElement("div");
    div.innerHTML = value;
    var text = div.textContent || div.innerText || "";
    return text;
});

Vue.filter("currency", function(value) {
    return "৳ " + parseFloat(value).toFixed(2);
});
Vue.filter("round", function(value) {
    return parseFloat(value).toFixed(0);
});

const edu = new Vue({
    el: "#app",
    i18n,
    components: {},

    methods: {},
    mounted() {
        console.log("d" + document.documentElement.lang.substr(0, 2));
    }
});